/* global define, nmlImpl */

// LanguageTrigger, dwilk's first behavior (based on stripped-down Motion Trigger)

define([],
  function () {
	"use strict";
				 
	function setupTriggerableLayer (args, paramID)
	{
		var bHideSiblings = true;

		var aLayers = args.getStaticParam(paramID);

		aLayers.forEach(function (lay) {
			lay.setTriggerable(bHideSiblings);
		});
	}
	  
	function defineLayer (id, uiName, match, uiToolTip0)
	{
		var def = { 
				id: id, type: "layer", uiName: uiName,
				dephault: { match: "//" + match },
		};
		
		if (uiToolTip0) {
			def.uiToolTip = uiToolTip0;
		}
		
		return def;
	}
	
	var aLayerTags = [
		{
			id: "Adobe.LanguageTrigger.LangLayer",
			artMatches: ["en_US", "fr_FR", "de_DE", "ja_JP", "es_ES", "it_IT", "ko_KR", "pt_BR", "ru_RU", "zh_CN"],
			uiName: "Language Layer",
			tagType: "layertag",
		}				
	];

	
	var aLayerParamDefs = [
		defineLayer("LangLayer",
					"Lang Layer Param",
					 "Adobe.LanguageTrigger.LangLayer",
					 "LangLayerToolTip"),
	];
	
	return {
		about:			"Language Trigger, copyright 2016.",
		description:	"Language Trigger desc",
		uiName:  		"Language Trigger",
		hideInBehaviorList: true,
		
		defineTags: function () {
			return {aTags: aLayerTags};
		},
		
		defineParams : function () {
			var aParams = [];
			
			aLayerParamDefs.forEach(function (def) {
				aParams.push(def);
			});

			return aParams;
		},

		onCreateBackStageBehavior : function (/*self*/) {
			return { order: 1.0, importance : 0.0 };
		},

		onCreateStageBehavior : function (self, args) {
			aLayerParamDefs.forEach(function (def) {
				setupTriggerableLayer(args, def.id);
			});
		},

		onAnimate : function (self, args) {
			var layerToShow = "LangLayer";

			var aLayers = args.getParam(layerToShow), bAnyTriggered = false, englishLayer = false,
				priority = 0.2;	// more than Cycle Layers (in particular its sustainTrigger())
			aLayers.forEach(function (lay) {
			
				if (lay.getName === "en_US" ) {
					englishLayer = lay;
				}
				// a bit of cheating here, but this is not intended for use beyond NUE
				// i think ultimate result would be to match a tag for each langCode
				
				if (lay.getName() === nmlImpl.langCode) {
					bAnyTriggered = true;
					lay.trigger(priority); // will show this one and hide its untriggered siblings
				}
			});
			
			if (!bAnyTriggered && englishLayer) {
				englishLayer.trigger(priority);
			}
		}
	};
});
